package games.league;

import games.Player;
import games.scenarios.GameScenario;
import games.scenarios.SimpleTwoPlayersGameScenario;

import java.io.InputStream;
import java.util.Scanner;

import cecj.app.othello.OthelloBoard;
import cecj.app.othello.OthelloGame;
import cecj.app.othello.OthelloPlayer;


public class HeuristicPerformanceMeter {

	double[] wpc = { 1.00f, -0.25f, 0.10f, 0.05f, 0.05f, 0.10f, -0.25f, 1.00f, -0.25f, -0.25f,
			0.01f, 0.01f, 0.01f, 0.01f, -0.25f, -0.25f, 0.10f, 0.01f, 0.05f, 0.02f, 0.02f, 0.05f,
			0.01f, 0.10f, 0.05f, 0.01f, 0.02f, 0.01f, 0.01f, 0.02f, 0.01f, 0.05f, 0.05f, 0.01f,
			0.02f, 0.01f, 0.01f, 0.02f, 0.01f, 0.05f, 0.10f, 0.01f, 0.05f, 0.02f, 0.02f, 0.05f,
			0.01f, 0.10f, -0.25f, -0.25f, 0.01f, 0.01f, 0.01f, 0.01f, -0.25f, -0.25f, 1.00f,
			-0.25f, 0.10f, 0.05f, 0.05f, 0.10f, -0.25f, 1.00f };

	private OthelloPlayer player;

	public void readPlayer(InputStream input) {
		Scanner s = new Scanner(input);
		double[] playerWpc = new double[64];
		for (int i = 0; i < 64; i++) {
			playerWpc[i] = s.nextDouble();
		}
		player = new OthelloPlayer(playerWpc);

		System.out.println("Player = " + player);
	}

	private void testPlayer() {
		OthelloPlayer heuristic = new OthelloPlayer(wpc);
		GameScenario scenario1 = new SimpleTwoPlayersGameScenario(
			new Player[] { player, heuristic });
		GameScenario scenario2 = new SimpleTwoPlayersGameScenario(
			new Player[] { heuristic, player });
		OthelloGame game = new OthelloGame(new OthelloBoard());

		game.reset();
		System.out.println("Playing as black, the result is " + scenario1.play(game));
		System.out.println(game.getBoard());

		game.reset();
		System.out.println("Playing as white, the result is " + scenario2.play(game));
		System.out.println(game.getBoard());
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		HeuristicPerformanceMeter hpm = new HeuristicPerformanceMeter();
		hpm.readPlayer(System.in);
		hpm.testPlayer();
	}

}
