package games;

public interface Board extends Cloneable {
	public int countPieces(int i);

	public int getPiece(int row, int col);

	public int getPiece(int row, int col, int dir, int dist);

	public void setPiece(int row, int col, int dir, int dist, int currentPlayer);

	public boolean isEmpty(int row, int col);

	public GameMove getShiftedMove(int row, int col, int dir, int dist);

	public double evaluate(Player player);

	public int getValueAt(int row, int col);

	public Board clone();
}
