package cecj.app.othello;

import java.util.Random;

public class OthelloRandomPlayer1 extends OthelloPlayerFitnessCalculator {

	private static final float WPC_POSITION_RANGE = 5;	
	
	@Override
	protected OthelloPlayer getPlayer() {
		double[] wpc = new double[WPC_LENGTH];
		Random r = new Random(System.currentTimeMillis());
		
		for (int i = 0; i < WPC_LENGTH; i++) {
			wpc[i] = r.nextDouble() * WPC_POSITION_RANGE;
			if (r.nextBoolean()) {
				wpc[i] *= -1;
			}
		}
		
		return new OthelloPlayer(wpc);
	}

}
