package cecj.app.othello;

import java.util.Arrays;

import ec.util.MersenneTwisterFast;

import games.Player;

public class OthelloPlayer implements Player {
	private static final int WPC_LENGTH = 64;

	private double[] wpc;

	public OthelloPlayer() {
		this.wpc = new double[WPC_LENGTH];
	}
	
	public OthelloPlayer(double[] wpc) {
		this.wpc = wpc;
	}

	public double getValue(int row, int col) {
		return wpc[(row - 1) * OthelloBoard.size() + (col - 1)];
	}
	
	public double[] getWPC() {
		return wpc;
	}

	public void setValue(int row, int col, double value) {
		wpc[(row - 1) * OthelloBoard.size() + (col - 1)] = value; 
	}
	
	@Override
	public String toString() {
		return Arrays.toString(wpc);
	}
	
	public void randomize(MersenneTwisterFast random, double range) {
		for (int i = 0; i < WPC_LENGTH; i++) {
			wpc[i] = random.nextDouble() * range;
			if (random.nextBoolean()) {
				wpc[i] *= -1;
			}
		}
	}
}
