// This file is a part of Framsticks SDK.  http://www.framsticks.com/
// Copyright (C) 1999-2015  Maciej Komosinski and Szymon Ulatowski.
// See LICENSE.txt for details.

#ifndef _FRAMSG_H_
#define _FRAMSG_H_

#include <stdarg.h>

extern const char* MSG_LEVEL[];
#define FRAMSG_FORMAT "[%s] %s.%s: %s"

void FMprintf(const char *o,const char *m,int w,const char *bl, ...);
void FMprintf_va(const char *o,const char *m,int w,const char *bl,va_list va); //a different name than FMprintf - otherwise the compiler could confuse the "string" parameter with va_list and could call the wrong function
void printFM(const char *bl,...); //a shorthand for printf (a different name again to avoid the risk of confusion with the two functions above. This would be unlikely but possible when the argument types would match)
void FramMessage(const char *o,const char *m,const char *txt,int w);

void _FramMessageSingleLine(const char *o,const char *m,const char *txt,int w); //don't call this directly - it is used internally

#define FMLV_DEBUG -1
#define FMLV_INFO 0
#define FMLV_WARN 1
#define FMLV_ERROR 2
#define FMLV_CRITICAL 3

/*
w: weight (importance) of a message
-1:debugging information, not needed for final users
0: information
1: warning or corrected error
2: uncorrected error. can cause malfunction
3: serious error, causes side effects. user should save what can be saved and restart the application
*/

#endif
