// This file is a part of the Framsticks GDK.
// Copyright (C) 1999-2014  Maciej Komosinski and Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.framsticks.com/ for further information.

#include "genoobj.h"
#include <frams/util/extvalue.h>
#include <frams/model/autoname.h>
#include "collectionobj.h"

#define FIELDSTRUCT GenoObj
ParamEntry geno_paramtab[]=
{
{"Geno",1,14,"Geno","All information about a single genotype.\nThis is a genetics-only object which does not contain any performance data. See also: Genotype class"},
{"name",0,PARAM_NOSTATIC,"Name","s 0 40",GETSET(name),},
{"rawgenotype",0,PARAM_NOSTATIC+PARAM_READONLY,"Raw genotype","s 1",GETONLY(genotype),"Genotype, excluding the format specifier"},
{"info",0,PARAM_NOSTATIC,"Info","s 1",GETSET(info),"Additional information or comments",},
{"format",0,PARAM_NOSTATIC+PARAM_READONLY,"Format","d",GETONLY(format),"Genotype format",},
{"genotype",0,PARAM_NOSTATIC+PARAM_READONLY,"Genotype","s 1",GETONLY(string),},
{"isValid",0,PARAM_NOSTATIC+PARAM_READONLY,"Valid","d 0 1",GETONLY(isvalid),},
{"getConverted",0,PARAM_NOSTATIC,"get converted genotype","p oGeno(d format)",PROCEDURE(p_getconvert),},
{"f0genotype",0,PARAM_NOSTATIC+PARAM_READONLY,"f0 genotype","s 1",GETONLY(f0genotype),"converted to f0 genotype",},
{"new",0,0,"create new empty object","p oGeno()",PROCEDURE(p_new),},
{"newFromString",0,0,"create new object from supplied string argument","p oGeno(s genotype)",PROCEDURE(p_newfromstring),},
{"newFrom",0,0,"create new object","p oGeno(s genotype,d format,s name,s description)",PROCEDURE(p_newfrom),},
{"autoname",0,PARAM_NOSTATIC+PARAM_READONLY,"Autogenerated name","s",GETONLY(autoname),},
{"toVector",0,PARAM_READONLY+PARAM_NOSTATIC,"serialization support","oVector",GETONLY(toVector),},
{"newFromVector",0,0,"serialization support","p oGeno(oVector)",PROCEDURE(p_newfromvector),},
{0,0,0,},
};
#undef FIELDSTRUCT

void GenoObj::get_isvalid(ExtValue *ret)
{ret->setInt(isValid());}

void GenoObj::get_genotype(ExtValue *ret)
{ret->setString(getGene());}

void GenoObj::get_name(ExtValue *ret)
{ret->setString(getName());}

void GenoObj::get_autoname(ExtValue *ret)
{
Model m(*this);
ret->setString(AutoName::makeName(m));
}

int GenoObj::set_name(const ExtValue *v)
{setName(v->getString());
return PSET_CHANGED;}

void GenoObj::get_info(ExtValue *ret)
{ret->setString(getComment());}

void GenoObj::get_string(ExtValue *ret)
{ret->setString(shortString());}

void GenoObj::get_format(ExtValue *ret)
{ret->setInt(getFormat());}

int GenoObj::set_info(const ExtValue *v)
{setComment(v->getString());
return PSET_CHANGED;}

void GenoObj::get_f0genotype(ExtValue *ret)
{ret->setString(getConverted('0').getGene());}

void GenoObj::p_getconvert(ExtValue *args,ExtValue *ret)
{*ret=makeDynamicObjectAndDecRef(new Geno(getConverted((char)args[0].getInt())));}

void GenoObj::p_new(ExtValue *args,ExtValue *ret)
{*ret=makeDynamicObjectAndDecRef(new Geno());}

void GenoObj::p_newfromstring(ExtValue *args,ExtValue *ret)
{*ret=makeDynamicObjectAndDecRef(new Geno(args[0].getString()));}

void GenoObj::p_newfrom(ExtValue *args,ExtValue *ret)
{*ret=makeDynamicObjectAndDecRef(new Geno(args[3].getString(),(char)args[2].getInt(),
				 args[1].getString(),args[0].getString()));}

Param& GenoObj::getStaticParam()
{
#ifdef __CODEGUARD__
static GenoObj static_genoobj;
static Param static_genoparam(geno_paramtab,&static_genoobj);
#else
static Param static_genoparam(geno_paramtab);
#endif
return static_genoparam;
}

Param& GenoObj::getDynamicParam()
{
static Param dynamic_genoparam(geno_paramtab);
return dynamic_genoparam;
}

ParamInterface* GenoObj::getInterface() {return &getStaticParam();}

ExtObject GenoObj::makeStaticObject(Geno* g)
{return ExtObject(&getStaticParam(),(void*)g);}

ExtObject GenoObj::makeDynamicObject(Geno* g)
{return ExtObject(&getDynamicParam(),(DestrBase*)g);}

ExtObject GenoObj::makeDynamicObjectAndDecRef(Geno* g)
{
const ExtObject& o=makeDynamicObject(g);
g->decref();
return o;
}

Geno* GenoObj::fromObject(const ExtValue& v, bool warn)
{
return (Geno*)v.getObjectTarget(getStaticParam().getName(), warn);
}

void GenoObj::get_toVector(ExtValue *ret)
{
VectorObject *vec=new VectorObject;
vec->data+=new ExtValue(shortString());
vec->data+=new ExtValue(getName());
vec->data+=new ExtValue(getComment());
ret->setObject(ExtObject(&VectorObject::par,vec));
}

void GenoObj::p_newfromvector(ExtValue *args,ExtValue *ret)
{
VectorObject *vec=VectorObject::fromObject(args->getObject());
if (vec && (vec->data.size()>=3))
	{
	SString g=vec->get(0)?vec->get(0)->getString():"";
	SString n=vec->get(1)?vec->get(1)->getString():"";
	SString c=vec->get(2)?vec->get(2)->getString():"";
	*ret=makeDynamicObjectAndDecRef(new Geno(g,-1,n,c));
	}
else
	ret->setEmpty();
}
