package com.framsticks.framclipse.editors.outline;

import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

import com.framsticks.framclipse.editors.FramclipseEditor;
import com.framsticks.framclipse.internal.parser.ElementWithOffset;
import com.framsticks.framclipse.internal.parser.Node;


public class FramclipseEditorOutlinePage extends ContentOutlinePage
{
	private FramclipseEditor editor;
	private Object input;
	private FramclipseEditorOutlineContentProvider contentProvider;
	private FramclipseEditorOutlineLabelProvider labelProvider;
	
	boolean flag = false;
	
	public FramclipseEditorOutlinePage(FramclipseEditor editor)
	{
		super();
		this.editor = editor;
	}

	@Override
	public void createControl(Composite parent) {
		super.createControl(parent);
		TreeViewer viewer = getTreeViewer();
		contentProvider = new FramclipseEditorOutlineContentProvider(editor);
		viewer.setContentProvider(contentProvider);
		labelProvider = new FramclipseEditorOutlineLabelProvider(editor.getDocumentProvider().
				getDocument(editor.getEditorInput()));
		viewer.setLabelProvider(labelProvider);
		viewer.addSelectionChangedListener(this);

		//control is created after input is set
		if (input != null)
			viewer.setInput(input);
	}
	
	public void setInput(Object input)
	{
		this.input = input;
		update();
	}
	
	public void update()
	{
		if(Display.getCurrent() != null)
		{
			Display.getCurrent().asyncExec(new Runnable() {

				public void run() {
					
					TreeViewer viewer = getTreeViewer();

					if (viewer != null)
					{
						Control control = viewer.getControl();
						if (control != null && !control.isDisposed())
						{
							control.setRedraw(false);
							viewer.setInput(input);
							viewer.expandAll();
							control.setRedraw(true);
						}
					}

				}
				
			});
		}
	}
	
	ElementWithOffset getAncestorWithOffset(Node node)
	{
		if(node instanceof ElementWithOffset)
			return (ElementWithOffset)node;
		
		if(node.jjtGetParent() != null)
		{
			return getAncestorWithOffset(node.jjtGetParent());
		}
		
		return null;
	}

	@Override
	public void selectionChanged(SelectionChangedEvent event) {
		super.selectionChanged(event);
		//find out which item in tree viewer we have selected, and set highlight range accordingly
		
		if(flag)
		{
			flag = false;
			return;
		}

		ISelection selection = event.getSelection();
		if (!selection.isEmpty())
		{
			Node element = (Node)((IStructuredSelection) selection).getFirstElement();
			
			ElementWithOffset ancestor = getAncestorWithOffset(element);
			
			int start = ancestor.getBeginOffset();
			int len = ancestor.getEndOffset() - ancestor.getBeginOffset() + 1;

			try
			{
				editor.setHighlightRange(start, len, true);
				//editor.getSelectionProvider().setSelection(new TextSelection(start, len));
			}
			catch (IllegalArgumentException x)
			{
				editor.resetHighlightRange();
			}
		}
		else
		{
			editor.resetHighlightRange();
		}
	}
	
	public void setSelectedElement(Node element)
	{
		if(element != null)
		{
			flag = true;
			getTreeViewer().setSelection(new StructuredSelection(element), true);
			
			ElementWithOffset ancestor = getAncestorWithOffset(element);
			
			int start = ancestor.getBeginOffset();
			int len = ancestor.getEndOffset() - ancestor.getBeginOffset() + 1;

			try
			{
				editor.setHighlightRange(start, len, false);
				//editor.getSelectionProvider().setSelection(new TextSelection(start, len));
			}
			catch (IllegalArgumentException x)
			{
				editor.resetHighlightRange();
			}

		}
		else
		{
			editor.resetHighlightRange();
		}
	}
}
