package com.framsticks.framclipse.editors.configuration;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

import com.framsticks.framclipse.internal.parser.ParseException;
import com.framsticks.framclipse.internal.parser.TokenMgrError;

public abstract class ErrorHandler<T extends Throwable> {

	public IMarker createMarker(IResource resource, T error) throws CoreException {
		IMarker marker = resource.createMarker(IMarker.PROBLEM);
		marker.setAttribute(IMarker.LINE_NUMBER, getLine(error));
		marker.setAttribute(IMarker.MESSAGE, getMessage(error));
		marker.setAttribute(IMarker.PRIORITY, IMarker.PRIORITY_HIGH);
		marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_ERROR);
		return marker;
	}

	public abstract int getLine(T error);

	public abstract String getMessage(T error);

	public static class ParseErrorHandler extends ErrorHandler<ParseException> {

		@Override
		public int getLine(ParseException e) {
			return e.currentToken.next.beginLine;
		}

		@Override
		public String getMessage(ParseException e) {
			return e.getMessage();
		}
	}

	public static class TokenErrorHandler extends ErrorHandler<TokenMgrError> {

		@Override
		public int getLine(TokenMgrError e) {
			return 1;
		}
		
		@Override
		public String getMessage(TokenMgrError e) {
			return e.getMessage();
		}		
	}

}
