package com.framsticks.framclipse.syntaxColoring;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

import com.framsticks.framclipse.Framclipse;


public class FramclipseCommentScanner extends RuleBasedScanner 
{
	public FramclipseCommentScanner()
	{
		ColorManager colorManager = Framclipse.getDefault().getColorManager();
		
		IToken string = new Token(new TextAttribute(colorManager
				.getColor(FramclipseColors.STRING)));
		IToken def = new Token(new TextAttribute(colorManager
				.getColor(FramclipseColors.COMMENT)));
		

		List<IRule> rules = new ArrayList<IRule>();
		rules.add(new SingleLineRule("\"", "\"", string, '\\'));
		rules.add(new SingleLineRule("\'", "\'", string, '\\'));
		
		setDefaultReturnToken(def);

		IRule[] result = new IRule[rules.size()];
		result = rules.toArray(result);
		setRules(result);

	}
}
