package com.framsticks.framclipse.internal.parser;

import org.eclipse.jface.text.IDocument;

public abstract class ElementWithOffset extends SimpleNode
{

	private int beginOffset;
	private int endOffset;
	
	public ElementWithOffset(int i) {
		super(i);
	}
	

	public ElementWithOffset(FramclipseNonScriptParser p, int i) {
		super(p, i);
	}


	public int getBeginOffset() {
		return beginOffset;
	}

	public void setBeginOffset(int offset) {
		this.beginOffset = offset;
	}

	public int getEndOffset() {
		return endOffset;
	}

	public void setEndOffset(int offset) {
		this.endOffset = offset;
	}
	
	static boolean withinInterval(int val, int loInclusive, int hiInclusive)
	{
		if(val >= loInclusive && val <= hiInclusive)
			return true;
		return false;
	}
	
	public Node getElementForOffset(int offset)
	{
		if(offset < beginOffset || offset > endOffset)
			return null;
		
		if(children != null)
		{
			for(int k = 0; k < children.length; ++k)
			{
				if(children[k] instanceof ElementWithOffset)
				{
					ElementWithOffset child = (ElementWithOffset)children[k];
					if(withinInterval(offset, child.beginOffset, child.endOffset))
						return child.getElementForOffset(offset);
				}
			}
		}
		
		return this;
	}
	
	public boolean isEquivalent(ElementWithOffset element, IDocument document)
	{
		if(!this.getClass().toString().equals(element.getClass().toString()))
			return false;
		
		if(jjtGetNumChildren() != element.jjtGetNumChildren())
			return false;
		
		if(getEndOffset() - getBeginOffset() != element.getEndOffset() - element.getBeginOffset())
			return false;
		
		if(children != null)
			for(int k = 0; k < children.length; ++k)
				if(children[k] instanceof ElementWithOffset)
					if(!(element.children[k] instanceof ElementWithOffset) || 
							!((ElementWithOffset)children[k]).isEquivalent((ElementWithOffset)element.children[k], document))
							return false;
		
		return true;
	}

}
