package com.framsticks.framclipse.editors.configuration;

import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.xpath.XPath;

import com.framsticks.framclipse.Framclipse;
import com.framsticks.framclipse.editors.EditorType;


public class FramclipseDocumentSetupParticipant implements IDocumentSetupParticipant {

	private final EditorType editorType;

	public FramclipseDocumentSetupParticipant(EditorType editorType) {
		this.editorType = editorType;
	}

	/*
	 * @see org.eclipse.core.filebuffers.IDocumentSetupParticipant#setup(org.eclipse.jface.text.IDocument)
	 */
	public void setup(IDocument document) {
		if (document instanceof IDocumentExtension3) {
			IDocumentExtension3 extension3 = (IDocumentExtension3) document;
			FramscriptPartitionScanner scanner = Framclipse.getDefault()
					.getFramscriptPartitionScanner(getCodeFieldName());
			IDocumentPartitioner partitioner = new FastPartitioner(scanner,
					FramscriptPartitionScanner.PARTITION_TYPES);
			extension3.setDocumentPartitioner(Framclipse.FRAMSCRIPT_PARTITIONING, partitioner);
			partitioner.connect(document);
		}
	}

	private String getCodeFieldName() {
		Document context = Framclipse.getDefault().getFramscriptContext();
		try {
			String query = "//file[@pattern='*." + editorType.getExtension() + "']/code";
			XPath xpath = XPath.newInstance(query);
			Element code = (Element) xpath.selectSingleNode(context);
			Attribute codeFieldNameAttribute = code.getAttribute("member");
			return codeFieldNameAttribute.getValue();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "";
	}
}
