// This file is a part of the Framsticks GDK.
// Copyright (C) 2002-2014  Maciej Komosinski and Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.framsticks.com/ for further information.

#include "framsg.h"
#include <common/nonstd_stdio.h>
#include "stl-util.h"
#include "Convert.h"

const char* MSG_LEVEL[]={"DEBUG","INFO","WARN","ERROR","CRITICAL"};

void FMprintf_va(const char *o,const char *m,int w,const char *bl,va_list va)
{
	string buf=ssprintf_va(bl,va);
	FramMessage(o,m,buf.c_str(),w);
}

void FMprintf(const char *o,const char *m,int w,const char *bl, ...)
{
	va_list argptr;
	va_start(argptr,bl);
	FMprintf_va(o,m,w,bl,argptr);
	va_end(argptr);
}

void printFM(const char *bl,...)
{
	va_list argptr;
	va_start(argptr,bl);
	FMprintf_va("Message","printf",FMLV_INFO,bl,argptr);
	va_end(argptr);
}
