/**
 * @file Text Helper
 * @author Patryk Gliszczynski
 * @version 1.0
 */

var Text = {
	styleRegex: /<style>.*<\/style>/,
	numberRegex : /-?\d+(\.\d+)?/g,
	roundMatch: function(match) {
        return roundNumber(match,2).toString();
    },

  getGenotypeMesh: function(genotype,genotypeType) {
	const genman = new Module.GenMan();
	genotype = genotype.replace(this.numberRegex, this.roundMatch);
	genotype = genotype.replaceAll("\n","⤶");
    if (genotype.length > 20) {
       genotype = genotype.slice(0,30) + "..."
    }
    var element = document.createElement("div");
    element.innerHTML = genman.HTMLize(genotype).c_str();
	element.innerHTML = element.innerHTML.replace(this.styleRegex,"").replace(genotypeType,"");
	Module.destroy(genman);
    return new CSS3DObject(element);
  },

  getFitnessMesh: function(fitness) {
    var element = document.createElement("div");
    element.className = "fitness";
    element.textContent = fitness;
    return new CSS3DObject(element);
  },

  getInfoMesh: function(info) {
    var element = document.createElement("div");
    element.className = "info";
    element.textContent = info;
    return new CSS3DObject(element);
  }
}
