/**
 * @file World Object
 * @author Patryk Gliszczynski
 * @version 1.0
 */

class World {
  /**
  * Class used for storing all the objects visualized in the animation.
  */

  constructor(camera, scene) {
    this.camera = camera;
    this.scene = scene;
    this.ground = this.Ground();
    this.lights = this.Lighting();
    this.sky = this.Sky();
    this.sun = this.Sun();
  }

  Ground() {
    let texture = new THREE.TextureLoader().load(Config.Ground.TEXTURE);
    texture.wrapS = texture.wrapT = THREE.RepeatWrapping;
    texture.repeat.set(Config.Ground.REPEAT, Config.Ground.REPEAT);
    texture.anisotropy = Config.Ground.ANISOTROPY;
	texture.colorSpace = THREE.SRGBColorSpace;

    let geometry = new THREE.PlaneGeometry(Config.Ground.WIDTH, Config.Ground.WIDTH);
    let material = new THREE.MeshLambertMaterial({map: texture});
    let ground = new THREE.Mesh(geometry, material);
    ground.position.y = Config.Ground.Y_POS;
    ground.rotation.x = Config.Ground.X_ROT;
    ground.receiveShadow = Config.Ground.RECEIVE_SHADOW;
    this.scene.add(ground)
    return ground
  }

  createTable(genotypes,genotypeEncoding){
	this.table = this.Table(genotypes,genotypeEncoding);
  }

  setGenotypes(genotypes, genotypeEncoding){
	this.table.genotypes = genotypes;
	for (let i = 0; i < this.table.genotypes.length; i++) {
		this.scene.remove(this.table.genotypePlanks[i].textMesh);
		// this.table.genotypePlanks[i] = new GenotypePlank(genotypes[i],genotypeEncoding,i);
		this.table.genotypePlanks[i].updateGenotype(genotypes[i],genotypeEncoding);
		this.scene.add(this.table.genotypePlanks[i].textMesh);
		this.table.fitnessPlanks[i].updateFitness((Math.random() * 100).toFixed(2));
	}
  }

  Table(genotypes,genotypeEncoding) {
    let table = new Table(genotypes,genotypeEncoding);
    this.scene.add(table.board);
    this.scene.add(table.genotypeHeader.mesh);
    this.scene.add(table.genotypeHeader.textMesh);
    this.scene.add(table.fitnessHeader.mesh);
    this.scene.add(table.fitnessHeader.textMesh);
    for (let i = 0; i < table.genotypes.length; i++) {
      this.scene.add(table.genotypePlanks[i].mesh);
      this.scene.add(table.genotypePlanks[i].textMesh);
      this.scene.add(table.fitnessPlanks[i].mesh);
      this.scene.add(table.fitnessPlanks[i].textMesh);
    }
    return table
  }

  Lighting() {
    let lights = [new THREE.AmbientLight(Config.Light.Ambient.COLOR)];
    let light = new THREE.DirectionalLight(Config.Light.Directional.COLOR,
                                           Config.Light.Directional.INTENSITY);
    light.position.set(Config.Light.Directional.X_POS,
                       Config.Light.Directional.Y_POS,
                       Config.Light.Directional.Z_POS);
    light.castShadow = Config.Light.Directional.CAST_SHADOW;
    light.shadow.mapSize.width = Config.Light.Directional.Shadow.MapSize.WIDTH;
    light.shadow.mapSize.height = Config.Light.Directional.Shadow.MapSize.HEIGHT;
    light.shadow.camera.left = Config.Light.Directional.Shadow.Camera.LEFT;
    light.shadow.camera.right = Config.Light.Directional.Shadow.Camera.RIGHT;
    light.shadow.camera.top = Config.Light.Directional.Shadow.Camera.TOP;
    light.shadow.camera.bottom = Config.Light.Directional.Shadow.Camera.BOTTOM;
    light.shadow.camera.far = Config.Light.Directional.Shadow.Camera.FAR;
    lights.push(light);

    for (let i = 0; i < lights.length; i++) {
      this.scene.add(lights[i]);
    }
    return lights;
  }

  Sky() {
    let sky = new Sky()
    sky.scale.setScalar(Config.Sky.SCALE);
    sky.material.uniforms.turbidity.value = Config.Sky.TURBIDITY;
    sky.material.uniforms.rayleigh.value = Config.Sky.RAYLEIGH;
  	// sky.material.uniforms.luminance.value = Config.Sky.LUMINANCE;
    sky.material.uniforms.mieCoefficient.value = Config.Sky.MIE_COEFFICIENT;
    sky.material.uniforms.mieDirectionalG.value = Config.Sky.MIE_DIRECTIONAL_G;
    this.scene.add(sky);
    return sky;
  }

  Sun() {
    let sun = new THREE.Mesh(
      new THREE.SphereGeometry(Config.Sun.RADIUS, Config.Sun.WIDTH_SEGMENTS, Config.Sun.HEIGHT_SEGMENTS),
      new THREE.MeshBasicMaterial({color: Config.Sun.COLOR})
    );
    sun.position.y = Config.Sun.Y_POS;

    let theta = Math.PI * (Config.Sun.INCLINATION - 0.5);
    let phi = 2 * Math.PI * (Config.Sun.AZIMUTH - 0.5);
    sun.position.x = 400000 * Math.cos(phi);
    sun.position.y = 400000 * Math.sin(phi) * Math.sin(theta);
    sun.position.z = 400000 * Math.sin(phi) * Math.cos(theta);
    this.sky.material.uniforms.sunPosition.value.copy(sun.position);
    this.scene.add(sun);
    return sun;
  }
}
