/**
 * @file Configuration File
 * @author Patryk Gliszczynski
 * @version 1.0
 */

var Config = {

  Simulation: {
    MUTATION_PROBABILITY: 0.5,
    CROSSOVER_PROBABILITY: 0.3,
    EVOLUTION_MAX_REPETITIONS: 100,
	NUMBER_OF_GENOTYPES: 6,
	INITIAL_MUTATIONS: 10,
	GENOTYPE: "/*4*/",

    Timing: {
      INITIAL: 1000,
      EVOLUTION_METHOD_SELECTION: 1000,
      GENOTYPE_SELECTION: 3500,
      EVOLUTION_RESULT: 100,
      EVOLUTION_RETURN: 100,
      SHOW_FRAMSTICK: 3500,
      DESTROY_FRAMSTICK: 2500,
      SHOW_RESULT: 2500
    },

    Element: {
      Position: {
        RESULT_TEXT: {x: 400, y: 305, z: -105},
        MUTATION_TEXT: {x: 400, y: 460, z: -277},
        CROSSOVER_TEXT: {x: 400, y: 540, z: -277},
        FITNESS_TEXT: {x: 400, y: 300, z: 485},
        EVOLVED_GENOTYPE_PLANK: {x: 400, y: 240, z: 0},
		NEURAL_NETWORK: {x: 400, y: 100, z: 300},
        EVOLVED_FITNESS_PLANK: {x: 400, y: 240, z: 380},
        MUTATION_GENOTYPE_PLANK: {x: 400, y: 400, z: 0},
        MUTATION_FITNESS_PLANK: {x: 400, y: 400, z: 380},
        CROSSOVER_GENOTYPE_PLANK1: {x: 400, y: 400, z: 0},
        CROSSOVER_FITNESS_PLANK1: {x: 400, y: 400, z: 380},
        CROSSOVER_GENOTYPE_PLANK2: {x: 400, y: 480, z: 0},
        CROSSOVER_FITNESS_PLANK2: {x: 400, y: 480, z: 380}
      },

      Angle: {
          SIDE_VIEW: {y: -Math.PI / 2},
          NORMAL: {y: 0}
      }
    },

    Camera: {
      SPEED: 1800,
      Position: {
        TABLE: {x: 0, y: 100, z: 1200},
        FRAMSTICK: {x: -723, y: 454, z: -4},
        SIDE_VIEW: {x: -972, y: 206, z: -14}
      }
    }
  },

  Camera: {
    FOV: 60,
    ASPECT: window.innerWidth / window.innerHeight,
    NEAR: 0.1,
    FAR: 2000000,
    X_POS: 0,
    Y_POS: 100,
    Z_POS: 1200
  },

  Controls: {
    AUTO_ROTATE: false,
    AUTO_ROTATE_SPEED: 1,
    MIN_DISTANCE: 100,
    MAX_DISTANCE: 1500,
    MAX_POLAR_ANGLE: Math.PI / 2.2
  },

  Light: {
    Ambient: {
      COLOR: 0xffffff
    },

    Directional: {
      COLOR: 0xffffff,
      INTENSITY: 2,
      X_POS: 50,
      Y_POS: 200,
      Z_POS: 100,
      CAST_SHADOW: true,

      Shadow: {
        MapSize: {
          WIDTH: 2048,
          HEIGHT: 2048
        },

        Camera: {
          LEFT: -2000,
          RIGHT: 2000,
          TOP: 2000,
          BOTTOM: -2000,
          FAR: 1000
        }
      }
    }
  },

  WebGLRenderer: {
    WIDTH: window.innerWidth,
    HEIGHT: window.innerHeight,
    PIXEL_RATIO: window.devicePixelRatio,
    ANTIALIAS: true,
    GAMMA_INPUT: true,
    GAMMA_OUTPUT: true,

    ShadowMap: {
      ENABLED: true,
      SINGLE_SIDED: false
    }
  },

  CSS3DRenderer: {
    WIDTH: window.innerWidth,
    HEIGHT: window.innerHeight,
    POSITION: "absolute",
    TOP: 0
  },

  Fog: {
    BACKGROUND: 0xb8edfc,
    NEAR: 3000,
    FAR: 15000
  },

  Sky: {
    SCALE: 450000,
    TURBIDITY: 3,
    RAYLEIGH: 0.21,
    LUMINANCE: 0.1,
    MIE_COEFFICIENT: 0.005,
    MIE_DIRECTIONAL_G: 1
  },

  Sun: {
    RADIUS: 20000,
    WIDTH_SEGMENTS: 16,
    HEIGHT_SEGMENTS: 8,
    COLOR: 0xffffff,
    INCLINATION: 0.182,
    AZIMUTH: 0.193,
    Y_POS: -700000
  },

  Ground: {
    TEXTURE: "https://raw.githubusercontent.com/mrdoob/three.js/master/examples/textures/terrain/grasslight-big.jpg",
    REPEAT: 25,
    ANISOTROPY: 16,
    WIDTH: 25000,
    Y_POS: -40,
    X_ROT: -Math.PI / 2,
    RECEIVE_SHADOW: true
  },

  NeuroViewer: {
	layoutType: 2,
	emptyLabel: "No neural network",
	canvas: {
	  id: "neuro-viewer-canvas",
	  drawMarginInPx: 20,
	  font: "14px Lucida Grande, sans-serif",
	  strokeStyle: '#DEDEDE'
	},
  },

  Framstick: {
    COLOR: 0xcacaca,
    Y_POS: 100,
    X_ROT: -Math.PI / 2,
    CAST_SHADOW: true,
    CAST_SHADOW: true,

	

    Tween: {
      Scale: {
        Up: {
          SIZE: 100,
          EASING: TWEEN.Easing.Quadratic.InOut
        },
        Down: {
          SIZE: 80,
          EASING: TWEEN.Easing.Quadratic.InOut
        },
        SPEED: 500
      },

      Rotate: {
        SPEED: 1000,
        EASING: TWEEN.Easing.Linear.None
      }
    },

    Geometry: {
      PART: {
        defaultShape: {
          radius: Module.Part.prototype.BALL_AND_STICK_RADIUS,
          segments: 16
        },
        ellipsoidShape: {
          radius: 1,
          segments: 32
        }
      },
      JOINT: {
        cylinderShape: {
		  thickness: 0.8,
          radius: undefined, // if undefined -> depends on Part radius
          radiusSegments: 10,
          isTransparent: false,
          opacity: 1
        },
        linkShape: {
          radius: 0.04,
          radiusSegments: 10,
          isTransparent: true,
          opacity: 0.2
        }
      }
    }
  },

  Table: {
    Board: {
      X_POS: 0,
      Z_POS: -500,
      WIDTH: 800,
      THICKNESS: 50,
      SPACING: 25,
      TEXTURE: "https://raw.githubusercontent.com/mrdoob/three.js/dev/examples/textures/brick_diffuse.jpg",
      REPEAT: 1,
      ANISOTROPY: 8
    },

    GenotypePlank: {
      X_POS: -70,
      Z_POS: -470,
      WIDTH: 600,
      HEIGHT: 65,
      THICKNESS: 10,
      TEXTURE: "js/hardwood2_diffuse_brighter.jpg",
      REPEAT: 3,
      ANISOTROPY: 8,
      CAST_SHADOW: true,
      RECEIVE_SHADOW: true,

      Tween: {
        Move: {
          SPEED: 1000,
          EASING: TWEEN.Easing.Quadratic.Out
        },

        Rotate: {
          SPEED: 1000,
          EASING: TWEEN.Easing.Quadratic.Out
        }
      }
    },

    FitnessPlank: {
      X_POS: 310,
      Z_POS: -470,
      WIDTH: 150,
      HEIGHT: 65,
      THICKNESS: 10,
      TEXTURE: "js/hardwood2_diffuse_brighter.jpg",
      REPEAT: 1,
      ANISOTROPY: 8,
      CAST_SHADOW: true,
      RECEIVE_SHADOW: true,

      Tween: {
        Move: {
          SPEED: 1000,
          EASING: TWEEN.Easing.Quadratic.Out
        },

        Rotate: {
          SPEED: 1000,
          EASING: TWEEN.Easing.Quadratic.Out
        }
      }
    }
  },

  Arrow: {
    WIDTH: 30,
    LENGTH: 100,
    FACES: 32,
    TEXTURE: "js/hardwood2_diffuse_brighter.jpg",
    REPEAT: 1,
    ANISOTROPY: 8,
    CAST_SHADOW: true,
    RECEIVE_SHADOW: true,
    X_POS: -500,
    Z_POS: -500,
    Z_ROT: -Math.PI / 2,

    Tween: {

      Scale: {
        Up: {
          SIZE: 1,
          SPEED: 300,
          EASING: TWEEN.Easing.Quadratic.InOut
        }
      },

      Move: {
        Right: {
          X_POS: -450,
          SPEED: 300,
          EASING: TWEEN.Easing.Quadratic.InOut
        },

        Left: {
          X_POS: -500,
          SPEED: 300,
          EASING: TWEEN.Easing.Quadratic.InOut
        }
      }
    }
  }
};


if (!Config.Framstick.Geometry.JOINT.cylinderShape.radius) {
	Config.Framstick.Geometry.JOINT.cylinderShape.radius = Config.Framstick.Geometry.PART.defaultShape.radius * Config.Framstick.Geometry.JOINT.cylinderShape.thickness;
}
