class Button{

	inactiveClass = "inactive";

	constructor(element, text, callback){
		this.parent = element;
		this.text = text;
		this.callback = callback;
		this.htmlString = `
			 <button type="button" class="rater-button control-container ${this.inactiveClass}">${text}</button> 
		`

		const parser = new DOMParser();
		const doc = parser.parseFromString(this.htmlString, 'text/html');
		this.DOMhtml = doc.body.firstChild;
		this.parent.appendChild(this.DOMhtml);

		this.DOMhtml.onclick = callback;
	}

	activate(){
		this.DOMhtml.classList.remove(this.inactiveClass);
	}

	deactivate(){
		this.DOMhtml.classList.add(this.inactiveClass);
	}
}