/**
 * @file Framstick Object
 * @author Patryk Gliszczynski
 * @version 1.0
 */

 class Framstick {

  constructor(genotype) {
    this.genotype = genotype;
    this.parts = [];
    this.joints = [];
    this.meshes = [];
    this.partfactory = new PartMeshFactory(Config.Framstick.Geometry.PART);
    this.jointfactory = new JointMeshFactory(Config.Framstick.Geometry.JOINT);

    let helper = new THREE.Mesh();
    this.scaleUpSize = Config.Framstick.Tween.Scale.Up.SIZE
    this.scaleDownSize = Config.Framstick.Tween.Scale.Down.SIZE
    this.material = new THREE.MeshLambertMaterial({color: Config.Framstick.COLOR});
    this.loadFromGenotype(helper);

    let bbox = new THREE.Box3().setFromObject(helper);
    bbox.getCenter(helper.position);
    helper.position.multiplyScalar(-1);

    this.mesh = new THREE.Group();
    this.mesh.add(helper);

    helper.castShadow = Config.Framstick.CAST_SHADOW;
    helper.receiveShadow = Config.Framstick.RECEIVE_SHADOW;

    this.mesh.scale.set(0.01, 0.01, 0.01);
    this.mesh.position.y = Config.Framstick.Y_POS;
    this.mesh.rotation.x = Config.Framstick.X_ROT;
    this.mesh.castShadow = Config.Framstick.CAST_SHADOW;
    this.mesh.receiveShadow = Config.Framstick.RECEIVE_SHADOW;

    this.scaleUp();
    this.autoRotate();
  }

  scaleUp() {
    let scale = this.scaleUpSize;
    let speed = Config.Framstick.Tween.Scale.SPEED;
    let tween = new TWEEN.Tween(this.mesh.scale).to({x: scale, y: scale, z: scale}, speed);
    tween.easing(Config.Framstick.Tween.Scale.Up.EASING);
    tween.onComplete(this.scaleDown.bind(this));
    tween.start();
  }

  scaleDown() {
    let scale = this.scaleDownSize;
    let speed = Config.Framstick.Tween.Scale.SPEED;
    let tween = new TWEEN.Tween(this.mesh.scale).to({x: scale, y: scale, z: scale}, speed);
    tween.easing(Config.Framstick.Tween.Scale.Down.EASING);
    tween.onComplete(this.scaleUp.bind(this));
    tween.start();
  }

  autoRotate() {
    let speed = Config.Framstick.Tween.Rotate.SPEED;
    let tween = new TWEEN.Tween(this.mesh.rotation).to({z: this.mesh.rotation.z + Math.PI / 4}, speed);
    tween.easing(Config.Framstick.Tween.Rotate.EASING)
    tween.onComplete(this.autoRotate.bind(this));
    tween.start();
  }

/**
* Code below was taken from: http://fugue.synology.me:30000/grzegorzlatosinski/framsticks-js
* @author Grzegorz Latosiński
* @pull_date 22.01.2018
*/
  loadFromGenotype(mesh) {
    let model = this.getModelFromGenotype(this.genotype);

    if (typeof model !== 'undefined') {
       let partsforjoints = [];
       this.meshes = [];
       this.parts = [];
       this.joints = [];

       for (let i = 0; i < model.getPartCount(); i++) {
           let m = this.partfactory.create(model.getPart(i));
           partsforjoints.push(m.userData);
           mesh.add(m)
           this.parts.push(m);
		   this.meshes.push(m);
       }

       for (let i = 0; i < model.getJointCount(); i++) {
           let m = this.jointfactory.create(model.getJoint(i), partsforjoints);
           mesh.add(m);
           this.joints.push(m);
		   this.meshes.push(m);
       }
       Module.destroy(model);
    }
  }

  getModelFromGenotype(genotype) {
    let genetics = new Module.PreconfiguredGenetics();
    let stringObj = new Module.SString();
    stringObj.set(genotype);
    let genoObj = new Module.Geno(stringObj);

    if (!genoObj.isValid()) {
       Module.destroy(stringObj);
       Module.destroy(genoObj);
       Module.destroy(genetics);
       return;
    }

    let model = new Module.Model(genoObj, Module.Model["SHAPETYPE_UNKNOWN"], true);
	model.open();
	model.close();
    Module.destroy(stringObj);
    Module.destroy(genoObj);
    Module.destroy(genetics);
    return model;
  }
}
