/**
 * @file Arrow Object
 * @author Patryk Gliszczynski
 * @version 1.0
 */

class Arrow {
  /**
   * Class reposnsible for the visualization of the cylindrical pointer.
   */

  constructor(y_pos) {
    var geometry = new THREE.ConeGeometry(Config.Arrow.WIDTH,
                                          Config.Arrow.LENGTH,
                                          Config.Arrow.FACES);

    let texture = new THREE.TextureLoader().load(Config.Arrow.TEXTURE);
    texture.wrapS = texture.wrapT = THREE.RepeatWrapping;
    texture.repeat.set(Config.Arrow.REPEAT, Config.Arrow.REPEAT);
    texture.anisotropy = Config.Arrow.ANISOTROPY;

    let material = new THREE.MeshLambertMaterial({map: texture});
    material.opacity = 0;
    // material.blending = THREE.NoBlending;

    this.mesh = new THREE.Mesh(geometry, material);
    this.mesh.castShadow = Config.Arrow.CAST_SHADOW;
    this.mesh.receiveShadow = Config.Arrow.RECEIVE_SHADOW;
    this.mesh.position.set(Config.Arrow.X_POS, y_pos, Config.Arrow.Z_POS)
    this.mesh.rotation.z += Config.Arrow.Z_ROT;
    this.mesh.scale.set(0.01, 0.01, 0.01);
    this.enlarge();
    this.goRight();
  }

  enlarge() {
    let scale = Config.Arrow.Tween.Scale.Up.SIZE;
    let speed = Config.Arrow.Tween.Scale.Up.SPEED;
    let tween = new TWEEN.Tween(this.mesh.scale).to({x: scale, y: scale, z: scale}, speed);
    tween.easing(Config.Arrow.Tween.Scale.Up.EASING);
    tween.start();
  }

  goRight() {
    let tween = new TWEEN.Tween(this.mesh.position).to({x: Config.Arrow.Tween.Move.Right.X_POS},
                                                       Config.Arrow.Tween.Move.Right.SPEED);
    tween.easing(Config.Arrow.Tween.Move.Right.EASING);
    tween.onComplete(this.goLeft.bind(this));
    tween.start();
  }

  goLeft() {
    let tween = new TWEEN.Tween(this.mesh.position).to({x: Config.Arrow.Tween.Move.Left.X_POS},
                                                       Config.Arrow.Tween.Move.Left.SPEED);
    tween.easing(Config.Arrow.Tween.Move.Left.EASING);
    tween.onComplete(this.goRight.bind(this));
    tween.start();
  }
}
