var NeuroFactory = function( config ) {

  var neuroClassHints = getNeuroClassHints();

  function getNeuroClassHints() {
    var hints = [ ];
    hints["Invisible"] = { name: "Invisible", value: Module.NeuroClass["Invisible"] };
    hints["DontShowClass"] = { name: "DontShowClass", value: Module.NeuroClass["DontShowClass"] };
    hints["AtFirstPart"] = { name: "AtFirstPart", value: Module.NeuroClass["AtFirstPart"] };
    hints["AtSecondPart"] = { name: "AtSecondPart", value: Module.NeuroClass["AtSecondPart"] };
    hints["EffectorClass"] = { name: "EffectorClass", value: Module.NeuroClass["EffectorClass"] };
    hints["ReceptorClass"] = { name: "ReceptorClass", value: Module.NeuroClass["ReceptorClass"] };
    hints["IsV1BendMuscle"] = { name: "V1BendMuscle", value: Module.NeuroClass["IsV1BendMuscle"] };
    hints["IsV1RotMuscle"] = { name: "V1RotMuscle", value: Module.NeuroClass["IsV1RotMuscle"] };
    hints["IsLinearMuscle"] = { name: "LinearMuscle", value: Module.NeuroClass["IsLinearMuscle"] };
    return hints;
  }

  function create( x, y, w, h, neuroData ) {

    var neuroClass = neuroData.getClass();
    if( neuroClass.getVisualHints() === neuroClassHints["ReceptorClass"].value ) {
      return new ReceptorDrawableNeuron(  x, y, w, h, neuroData, config );
    }

    return new GenericDrawableNeuron(  x, y, w, h, neuroData, config );

  }

  return {
    create: create
  }
};
