class Slider{

	constructor(element,name,setFunc){
		this.htmlId = `${name.toLowerCase()}_slider`
		this.htmlValueId = `${name.toLowerCase()}_value`
		this.min = 0;
		this.max = 1;
		this.step = 0.01;
		this.value = (this.min+this.max)/2;
		this.htmlString = `
			<div class="column control-container">
				<div class="row"><span>${name} Probability: </span><input type="number" step="0.01" max="1" min="0" id=${this.htmlValueId} class="slider-value" value="${this.value}"></input></div>
				<div class="row">
					<span>${this.min}.0</span>
					<input id="${this.htmlId}" type="range" min="${this.min}" max="${this.max}" value="${this.value}" class="slider" step="${this.step}">
					<span>${this.max}.0</span>
				</div>
			</div>
		`;
		const parser = new DOMParser();
		const doc = parser.parseFromString(this.htmlString, 'text/html');

		this.DOMhtml = doc.body.firstChild;
		this.parent = element;
		this.parent.appendChild(this.DOMhtml);
		this.DOMInput = document.getElementById(this.htmlId);
		this.DOMValue = document.getElementById(this.htmlValueId);
		this.DOMInput.oninput = function(){
			setFunc(this.value);
		}
		this.DOMValue.oninput = function(){
			setFunc(this.value);
		}
	}

	update(value){
		this.value = value;
		this.DOMValue.value = roundNumber(this.value,2);
		this.DOMInput.value = this.value;
	}
}