class Option{
	constructor(element, genotype){
		this.parent = element;
		this.genotype = genotype;
		this.fullGenotype = `/*${this.genotype}*/`

		const funcName = Object
			.keys(Module) //framsticks module
			.filter((k)=>{return k.startsWith("GenoConv_f"+this.genotype);})[0];
		const genoConv = new Module[funcName]();
		const genoConvHelper = new Module.GenoConvHelper(genoConv);

		this.genotypeDesc = genoConvHelper.getName();
		this.htmlString = `
			<option value="${this.genotype}" ${this.fullGenotype===Config.Simulation.GENOTYPE?"selected":""}>f${this.genotype} (${this.genotypeDesc})</option>
		`;

		const parser = new DOMParser();
		const doc = parser.parseFromString(this.htmlString, 'text/html');
		this.DOMhtml = doc.body.firstChild;
		this.parent.appendChild(this.DOMhtml);
		Module.destroy(genoConv);
		Module.destroy(genoConvHelper);
	}
}