package com.framsticks.structure.messages;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;

import org.apache.commons.lang3.StringUtils;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.Misc;
import com.framsticks.util.lang.Strings;

/**
 * @author Piotr Sniegowski
 */
@FramsClassAnnotation(order = {"type", "pos", "id", "hint"})
public class ListChange {

	public static enum Action {
		Add,
		Remove,
		Modify
	}


	public ListChange(Action action, Integer position, String identifier, Object... hints) {
		this.action = action;
		this.position = position;
		this.identifier = identifier;
		if (hints.length != 0) {
			this.hints = new TreeSet<>();
			for (Object h : hints) {
				this.hints.add(h.toString());
			}
		}
	}

	/**
	 *
	 */
	public ListChange() {
	}

	public Action getAction() {
		return action;
	}

	public Integer getPosition() {
		return position;
	}

	public String getIdentifier() {
		return identifier;
	}


	public boolean hasHint(String hint) {
		if (hints == null) {
			return false;
		}
		return hints.contains(hint);
	}


	public Action action = Action.Add;
	@ParamAnnotation(id = "pos", def = "-1")
	public Integer position;
	@ParamAnnotation(id = "id")
	public String identifier;

	protected Set<String> hints;

	@ParamAnnotation
	public String getHints() {
		return StringUtils.join(hints, ",");
	}

	@ParamAnnotation
	public void setHints(String hints) {
		if (!Strings.notEmpty(hints)) {
			this.hints = null;
			return;
		}
		this.hints = new TreeSet<>();
		this.hints.addAll(Arrays.asList(StringUtils.split(hints, ",")));
	}

	@ParamAnnotation
	public Integer getType() { return action.ordinal(); }
	@ParamAnnotation
	public void setType(Integer type) { action = Action.values()[type]; }

	public String getBestIdentifier() {
		if (Strings.notEmpty(identifier)) {
			return identifier;
		}
		return position.toString();
	}

	@Override
	public String toString() {
		StringBuilder b = new StringBuilder();
		b.append(action).append(" ").append(identifier).append(" ").append(position);
		if (hints != null && !hints.isEmpty()) {
			b.append(" ").append(getHints());
		}
		return b.toString();
	}

	@Override
	public boolean equals(Object object) {
		if (object instanceof ListChange) {
			ListChange r = (ListChange) object;
			return Misc.equals(action, r.action) && Misc.equals(position, r.position) && Misc.equals(identifier, r.identifier) && Misc.equals(hints, r.hints);
		}
		return false;
	}

}
