// This file is a part of Framsticks SDK.  http://www.framsticks.com/
// Copyright (C) 1999-2020  Maciej Komosinski and Szymon Ulatowski.
// See LICENSE.txt for details.

#ifndef _SIMIL_MEASURE_H
#define _SIMIL_MEASURE_H

#include "frams/genetics/geno.h"
#include "frams/model/model.h"
#include <assert.h>

class SimilMeasure
{
public:
	SimilMeasure();
	int measure_type;
	/// Interface to local parameters
	Param localpar;

	virtual ~SimilMeasure(){};
	virtual double getDistance() = 0;
	double evaluateDistance(const Geno *G0, const Geno *G1);
	virtual int setParams(std::vector<double> params) = 0;
    Model sampleSurface(Model *M, double density);

	#define STATRICKCLASS SimilMeasure
	PARAMPROCDEF(p_evaldistance);
	#undef STATRICKCLASS

protected:
	/// Genotypes between which distance is evaluated.
	const Geno *genos[2];
	/// Models created from the genotypes array
	Model *models[2];
	Model* newModel(const Geno *g);
};

#endif

