// This file is a part of Framsticks SDK.  http://www.framsticks.com/
// Copyright (C) 1999-2020  Maciej Komosinski and Szymon Ulatowski.
// See LICENSE.txt for details.

#ifndef _SIMIL_MEASURE_MDS_BASED_H
#define _SIMIL_MEASURE_MDS_BASED_H

#include "simil-measure.h"

class SimilMeasureMDSBased : public SimilMeasure
{
public:
	SimilMeasureMDSBased();
	virtual ~SimilMeasureMDSBased(){};
	virtual int setParams(std::vector<double> params)=0;
	bool with_alignment;
	bool save_matching;
	int fixedZaxis;
	int wMDS;
protected:
	double getDistance();
	virtual void prepareData()=0;
	virtual void beforeTransformation()=0;
	virtual double distanceForTransformation()=0;
	virtual double distanceWithoutAlignment()=0;
	int getPartPositions();
	bool computePartsPositionsByMDS();
	virtual void copyMatching()=0;
	virtual void cleanData()=0;
	int m_iSmaller;
	/// Positions of Parts of both of the compared structures. 
	Pt3D *coordinates[2];
};

#endif

