// This file is a part of Framsticks SDK.  http://www.framsticks.com/
// Copyright (C) 1999-2020  Maciej Komosinski and Szymon Ulatowski.
// See LICENSE.txt for details.

#ifndef HUNGARIAN_MEASURE_H
#define HUNGARIAN_MEASURE_H

#include "measure-mds-based.h"
#include "frams/genetics/geno.h"
#include "frams/model/model.h"
#include "hungarian/hungarian.h"

class SimilMeasureHungarian : public SimilMeasureMDSBased
{
public:
	SimilMeasureHungarian();
	~SimilMeasureHungarian(){};
	
	double distanceForTransformation();
	double distanceWithoutAlignment();
	
	static int getNOFactors();
	int setParams(std::vector<double> params);

	/// Table of weights for weighted distance function.
	/// Weights are for factors in the following order:
	/// [0]: m_iDV (difference in the number of vertices)
	/// [1]: m_iDD (difference in degrees over matching)
	/// [2]: m_iDN (difference in neurons over matching)
	/// [3]: m_dDG (difference in geometry over matching)
	/// @sa EvaluateDistance
	double m_adFactors[4];
	
	/// Interface to local parameters
	Param localpar;

protected:
	void prepareData();
	void beforeTransformation();
	void copyMatching();
	void cleanData();
	
	void countDegrees();
	void countNeurons();
	void fillPartsDistances(double*& dist, int bigger, int smaller, bool geo);
	double addNeuronsPartsDiff(double dist);
	
	//Smaller and greater structures sizes
	int nSmaller;
	int nBigger;
	
	//Vertex degrees for both structures
	int *degrees[2];
	
	//Count of neurons attached to each parts for both structures
	int *neurons[2];
	
	//Number of on-joint and unattached neurons for both structures
	int on_joint[2];
	int anywhere[2];
	
	//Temporary and final assignment
	int *assignment;
	std::vector<int> min_assignment;
	
	//Final and temporary parts distances
	double* parts_distances;
	double* temp_parts_distances;
	
	HungarianAlgorithm hungarian;
	
	/// Number of weights in the function which evaluates distance.
	static const int iNOFactors;
};


#endif /* HUNGARIAN_MEASURE_H */

