// This file is a part of Framsticks SDK.  http://www.framsticks.com/
// Copyright (C) 1999-2020  Maciej Komosinski and Szymon Ulatowski.
// See LICENSE.txt for details.

#ifndef DISTRIBUTION_MEASURE_H
#define DISTRIBUTION_MEASURE_H

#include "simil-measure.h"
#include "EMD/emd.h"

class SimilMeasureDistribution : public SimilMeasure
{
public:
	SimilMeasureDistribution();
	~SimilMeasureDistribution(){};
	int setParams(std::vector<double> params);
	void calculateFuns();
	void calculateFun(std::pair<double, float> *fun, Model &sampled);
	double compareFuns();
	double EMD(std::pair<double, float> *fun1, std::pair<double, float> *fun2);
	double density;
	int samples_num;
	int bin_num;
	/// Interface to local parameters
	Param localpar;

protected:
	std::pair<double, float> *funs[2];
	SolidsShapeTypeModel *sst_models[2];
	std::vector<double> (SimilMeasureDistribution::*distribution_fun)(int samples_taken, Model *sampled);

	void fillPointsWeights(std::pair<double, float> *fun, feature_t *points, float *weights);
	double getDistance();
	std::vector<double> D2(int samples_taken, Model *sampled);
	std::vector<double> D1(int samples_taken, Model *sampled);
	std::vector<double> D3(int samples_taken, Model *sampled);
	std::vector<double> D4(int samples_taken, Model *sampled);
	std::vector<double> A3(int samples_taken, Model *sampled);
};

#endif /* DISTRIBUTION_MEASURE_H */

