package com.framsticks.test;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.experiment.Experiment;
import com.framsticks.experiment.WorkPackageLogic;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.test.prime.PrimePackage;
import com.framsticks.util.dispatching.Future;

@FramsClassAnnotation
public class PrimeExperiment extends Experiment {
	private static final Logger log = LogManager.getLogger(PrimeExperiment.class);

	@ParamAnnotation
	public final WorkPackageLogic<PrimePackage> workPackageLogic;

	protected int maxNumber = 3000;
	protected int step = 100;
	protected int numberCounter = 1;

	/**
	 *
	 */
	public PrimeExperiment() {
		setExpdef("prime");

		workPackageLogic = new WorkPackageLogic<PrimePackage>(this) {

			@Override
			protected void generateNextPackage(Future<PrimePackage> future) {
				assert isActive();
				PrimePackage wp = new PrimePackage();

				log.debug("generated package: {}", wp);
				wp.params.from_number = numberCounter;
				numberCounter += step;
				wp.params.to_number = numberCounter - 1;
				wp.state.current_number = wp.params.from_number;
				wp.state.getResultList().clear();

				future.pass(wp);
			}
		};
	}

	protected void processFile() {
	}

}
