package com.framsticks.params;




import com.framsticks.params.types.ObjectParam;
import com.framsticks.util.FramsticksException;

/**
 * The Class SimpleAbstractAccess implements all the methods of Access
 * which actions can be implemented with usage of {@link Access} methods
 * or concern schema, which is stored in {@link #framsClass}
 *
 * Based on c++ class SimpleAbstractParam located in: cpp/gdk/param.*
 *
 * @author Jarek Szymczak <name.surname@gmail.com>, Mateusz Jarus (please
 *         replace name and surname with my personal data)
 *
 * @author Piotr Sniegowski
 */
public abstract class SimpleAbstractAccess implements ObjectAccess {

	protected final FramsClass framsClass;

	/**
	 * @param framsClass
	 */
	public SimpleAbstractAccess(FramsClass framsClass) {
		this.framsClass = framsClass;
	}

	@Override
	public final FramsClass getFramsClass() {
		return framsClass;
	}

	@Override
	public String getId() {
		return framsClass.getId();
	}

	@Override
	public int getParamCount() {
		return framsClass.getParamCount();
	}

	@Override
	public Param getParam(int i) {
		return framsClass.getParam(i);
	}

	@Override
	public Param getParam(String id) {
		return framsClass.getParam(id);
	}

	// @Override
	// public Param getGroupMember(int gi, int n) {
	// 	return framsClass.getGroupMember(gi, n);
	// }

	@Override
	public <T> T get(int i, Class<T> type) {
		return get(framsClass.getParamEntry(i, ValueParam.class), type);
	}

	@Override
	public <T> T get(String id, Class<T> type) {
		return get(framsClass.getParamEntry(id, ValueParam.class), type);
	}

	@Override
	public <T> int set(int i, T value) {
		return set(framsClass.getParamEntry(i, ValueParam.class), value);
	}

	@Override
	public <T> int set(String id, T value) {
		return set(framsClass.getParamEntry(id, ValueParam.class), value);
	}

	@Override
	public <T> int set(ValueParam param, T value) {

		//String id = param.getEffectiveId();
		try {
			Object oldValue = get(param, param.getStorageType());
			ReassignResult<?> result = param.reassign(value, oldValue);
			Object casted = result.getValue();
			if (casted != null && !casted.equals(oldValue)) {
				internalSet(param, casted);
			}
			return result.getFlags();
		} catch (CastFailure e) {
			throw new FramsticksException()
				.msg("casting failure while set")
				.arg("param", param)
				.arg("value", value)
				.arg("value's type", (value == null ? "<null>" : value.getClass().getCanonicalName()))
				.arg("in", this).cause(e);
		}
	}


	protected abstract <T> void internalSet(ValueParam param, T value);

	@Override
	public Iterable<Param> getParams() {
		return framsClass.getParamEntries();
	}

	@Override
	public int getCompositeParamCount() {
		return framsClass.getCompositeParamCount();
	}

	@Override
	public CompositeParam getCompositeParam(int number) {
		return framsClass.getCompositeParam(number);
	}

	@Override
	public ParamBuilder buildParam(ParamBuilder builder) {
		return builder.name(getId()).type(ObjectParam.class).containedTypeName(getId());
	}

}
