package com.framsticks.params;




import com.framsticks.params.types.EventParam;
import com.framsticks.params.types.ProcedureParam;

/**
 * @author Piotr Sniegowski
 */
public abstract class ListAccess implements Access {

	final Access elementAccess;
	final String containedTypeName;

	protected final ParamBuilder paramBuilder;

	public ListAccess(Access elementAccess) {
		this.elementAccess = elementAccess;
		this.containedTypeName = elementAccess.getId();
		paramBuilder = elementAccess.buildParam(new ParamBuilder());
	}

	// @Override
	// public Param getGroupMember(int gi, int n) {
	//	return null;
	// }


	public Access getElementAccess() {
		return elementAccess;
	}

	/**
	 * @return the containedTypeName
	 */
	public String getContainedTypeName() {
		return containedTypeName;
	}

	@Override
	public final FramsClass getFramsClass() {
		return elementAccess.getFramsClass();
	}

	@Override
	public void tryAutoAppend(Object object) {
		throw new InvalidOperationException().msg("It could actually be used also, the Access.select could be used to check whether type is correct");
	}

	@Override
	public Object call(String id, Object[] arguments) {
		throw new InvalidOperationException().msg("list access does not support calling methods").arg("id", id).arg("access", this);
	}

	@Override
	public Object call(ProcedureParam param, Object[] arguments) {
		throw new InvalidOperationException().msg("list access does not support calling methods").arg("param", param).arg("access", this);
	}

	@Override
	public void reg(EventParam param, EventListener<?> listener) {
		throw new InvalidOperationException().msg("list access does not support registering events").arg("param", param).arg("access", this);
	}

	@Override
	public void regRemove(EventParam param, EventListener<?> listener) {
		throw new InvalidOperationException().msg("list access does not support registering events").arg("param", param).arg("access", this);
	}


	@Override
	public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("list of ").append(containedTypeName);
		if (getSelected() != null) {
			b.append("[").append(getParamCount()).append("]");
		}
		return b.toString();
	}

	public CompositeParam prepareParamFor(String id) {
		return paramBuilder.id(id).finish(CompositeParam.class);
	}
};
