package com.framsticks.gui.console;

import java.util.LinkedList;
import java.util.List;

import com.framsticks.communication.Address;
import com.framsticks.communication.ClientSideRawConnection;
import com.framsticks.communication.ConnectionListener;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.dispatching.ThrowExceptionHandler;

@FramsClassAnnotation
public class DirectConsole extends InteractiveConsole implements ConnectionListener {

	/**
	 * @param connection
	 */
	public DirectConsole() {
	}


	@ParamAnnotation
	public DirectConsole setAddress(String address) {
		return setAddress(new Address(address));
	}

	public DirectConsole setAddress(Address address) {
		this.connection = new ClientSideRawConnection();
		this.connection.setAddress(address);
		return this;
	}

	/**
	 * @return the connection
	 */
	@Override
	public ClientSideRawConnection getConnection() {
		return (ClientSideRawConnection) connection;
	}


	protected void sendImplementation(String line) {
		getConnection().send(line, ThrowExceptionHandler.getInstance());
	}

	/**
	 * Creates commands tip list.
	 * @param startText Text that user typed.
	 */
	protected void findCompletionPropositions(String prefix) {
		List<String> propositions = new LinkedList<String>();
		for (String entry : history) {
			if (entry.startsWith(prefix)) {
				propositions.add(entry);
			}
		}
		processCompletionResult(prefix, propositions);
	}

	@Override
	protected void joinableStart() {
		super.joinableStart();
		connection.getListeners().add(this);
	}

	@Override
	protected void joinableInterrupt() {
		connection.getListeners().remove(this);
		super.joinableInterrupt();
	}

	@Override
	public void connectionOutgoing(String line) {
		dispatchWrite(line);
	}

	@Override
	public void connectionIncomming(String line) {
		dispatchWrite(line);
	}
}
