package com.framsticks.dumping;

import com.framsticks.params.Sink;

import java.io.PrintWriter;

/**
 * @author Piotr Sniegowski
 */
public class PrintWriterSink implements Sink {

    protected final PrintWriter stream;

    public PrintWriterSink(PrintWriter stream) {
        this.stream = stream;
    }

    @Override
    public PrintWriterSink print(String str) {
        stream.print(str);
        return this;
    }

    @Override
    public PrintWriterSink print(Object obj) {
        stream.print(obj);
        return this;
    }

    @Override
    public void breakLine() {
        stream.print('\n');
    }

    @Override
    public void close() {
    }
}
