package com.framsticks.test;

import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import com.framsticks.util.dispatching.Joinable;
import com.framsticks.util.dispatching.Monitor;

@Test
public abstract class MonitorBasedTest extends TestConfiguration {

	protected Monitor monitor;
	protected Joinable subject;

	protected abstract Joinable createSubject();

	@BeforeClass(timeOut = 2000)
	public void setUp() {
		subject = createSubject();

		monitor = new Monitor(subject);
		monitor.setTaskExceptionHandler(createExceptionHandler());
		monitor.use();

		setUpAfterUse();
	}

	protected void setUpAfterUse() {
	}

	@AfterClass(timeOut = 30000)
	public void tearDown() {
		monitor.drop().join();
	}
}
