package com.framsticks.test.prime;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;

@FramsClassAnnotation
public class ExpState {

	@ParamAnnotation
	public int current_number;

	protected final List<Integer> resultList = new ArrayList<>();

	@ParamAnnotation
	public String getResult() {
		return StringUtils.join(resultList, ",");
	}

	@ParamAnnotation
	public void setResult(String result) {
		resultList.clear();
		for (String s : StringUtils.split(result, ",")) {
			resultList.add(Integer.valueOf(s));
		}
	}

	/**
	 * @return the resultList
	 */
	public List<Integer> getResultList() {
		return resultList;
	}

	@Override
	public String toString() {
		return "(" + current_number + "):" + resultList;
	}
}
