package com.framsticks.gui.tree;

import java.awt.Component;

import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import com.framsticks.gui.ImageProvider;
import com.framsticks.params.CompositeParam;

/**
 * Renderer of Tree. Sets appropriate icons for nodes.
 */
@SuppressWarnings("serial")
public class TreeCellRenderer extends DefaultTreeCellRenderer {

	protected final TreeModel treeModel;


	/**
	 * @param treeModel
	 */
	public TreeCellRenderer(TreeModel treeModel) {
		this.treeModel = treeModel;
	}

	@Override
	public Component getTreeCellRendererComponent(JTree tree, Object value,
			boolean sel, boolean expanded, boolean leaf, int row,
			boolean hasFocus) {

		super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);

		if (value == null) {
			setText("!null value");
			return this;
		}

		if (!(value instanceof AbstractNode)) {
			setText("?");
			// treeModel.renderTreeObject(Casting.throwCast(TreeNode.class, value), this);
			return this;
		}
		((AbstractNode) value).render(this);

		return this;
	}

	public static String findIconName(CompositeParam param) {
		switch (param.getFramsTypeName()) {
			case "o Server": return ImageProvider.SERVER;
			case "o Simulator": return ImageProvider.SIMULATOR;
			case "o CLI": return ImageProvider.CLI;
			case "o World": return ImageProvider.WORLD;
			case "o GenePools": return ImageProvider.GENEPOOLS;
			case "l GenePool": return ImageProvider.SIMULATOR; //HERE
			case "o GenePool": return ImageProvider.GENEPOOLS_GROUP; //HERE

			case "o Populations": return ImageProvider.POPULATIONS;
			case "l Population": return ImageProvider.SIMULATOR; ///HERE
			case "o Population": return ImageProvider.POPULATION_GROUP;
			case "o ExpParams": return ImageProvider.EXPERIMENT;
			case "o stats": return ImageProvider.STATISTIC;
			case "l Genotype uid": return ImageProvider.GENOTYPES_GROUP;
			case "o Genotype": return ImageProvider.GENOTYPES;

			case "o Part": return ImageProvider.PART;
			case "o Joint": return ImageProvider.JOINT;
			case "o NeuroDef": return ImageProvider.NEURON_DEF;
			case "o NeuroConn": return ImageProvider.NEURON_DEF;

			case "o MechPart": return ImageProvider.MECH_PART;
			case "o MechJoint": return ImageProvider.MECH_JOINT;
			case "o Neuro": return ImageProvider.NEURON;

			case "l Part": return ImageProvider.PART_GROUP;
			case "l Joint": return ImageProvider.JOINT_GROUP;
			case "l NeuroDef": return ImageProvider.NEURON_DEF_GROUP;
			case "l NeuroConn": return ImageProvider.NEURON_DEF_GROUP;

			case "l MechPart": return ImageProvider.MECH_PART_GROUP;
			case "l MechJoint": return ImageProvider.MECH_JOINT_GROUP;
			case "l Neuro": return ImageProvider.NEURON_GROUP;

			case "o Creature": return ImageProvider.CREATURE;
			case "l Creature uid": return ImageProvider.CREATURES_GROUP;
			case "l Event id": return ImageProvider.EVENT;
			case "o Event": return ImageProvider.EVENT;

		}
		return ImageProvider.FOLDER_OPEN;
	}


}
