package com.framsticks.experiment;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.communication.File;
import com.framsticks.params.ListSource;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.dispatching.Future;
import com.framsticks.util.dispatching.FutureHandler;

@FramsClassAnnotation
public abstract class WorkPackageLogic<WP extends WorkPackage> extends AbstractExperimentLogic {

	private static final Logger log = LogManager.getLogger(WorkPackageLogic.class);

	@ParamAnnotation
	public final NetLoadSaveLogic netLoadSaveLogic;

	/**
	 * @param experiment
	 */
	public WorkPackageLogic(Experiment experiment) {
		super(experiment);

		netLoadSaveLogic = new NetLoadSaveLogic(experiment) {

			@Override
			public void netload(Simulator simulator, final Future<File> net) {
				assert experiment.isActive();
				log.debug("providing netload file for {}", simulator);

				generateNextPackage(new FutureHandler<WP> (net) {

					@Override
					protected void result(WP result) {
						log.debug("sending package: {}", result);
						File file = new File("test-file", ListSource.createFrom("# a test"));

						net.pass(file);
					}
				});

			}

			@Override
			public void netsave(Simulator simulator, File net) {
				// processFile();
			}
		};
	}


	protected abstract void generateNextPackage(Future<WP> future);

}
