package com.framsticks.experiment;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.communication.Address;
import com.framsticks.core.Path;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.remote.RemoteTree;
import com.framsticks.util.AutoAttacher;
import com.framsticks.util.Misc;
import com.framsticks.util.dispatching.Dispatcher;
import com.framsticks.util.dispatching.Dispatching;
import com.framsticks.util.dispatching.FutureHandler;
import com.framsticks.util.lang.Casting;
import com.framsticks.util.lang.Strings;

import static com.framsticks.core.TreeOperations.*;

@FramsClassAnnotation
public class SimulatorConnector implements AutoAttacher {
	private static final Logger log = LogManager.getLogger(SimulatorConnector.class);


	protected Experiment experiment;
	protected Address address;
	protected RemoteTree remoteTree;

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public void attachTo(Object parent) {
		experiment = Casting.throwCast(Experiment.class, parent);

		Misc.throwIfNull(address);
		log.debug("connecting to simulator at {}", address);
		// experiment
		remoteTree = new RemoteTree();
		remoteTree.setAddress(address);
		remoteTree.setDispatcher((Dispatcher) experiment.getDispatcher());


		experiment.getSimulatorCandidates().add(remoteTree);

		Dispatching.dispatchLog(remoteTree, log, Level.DEBUG, "first task in remote tree");

		tryGet(remoteTree, "/simulator", new FutureHandler<Path>(experiment) {

			@Override
			protected void result(Path result) {
				log.debug("resolved simulator path: {}", result);
				Misc.checkEquals(experiment.getExpdef(), bindAccess(result).get("expdef", String.class), "expdef mismatch in connected simulator", this);

				Simulator simulator = new Simulator(experiment, remoteTree, result);
				experiment.addSimulator(simulator);
				experiment.getSimulatorCandidates().remove(remoteTree);
			}
		});
	}

	@ParamAnnotation
	public void setAddress(String address) {
		this.address = new Address(address);
	}

	@ParamAnnotation
	public String getAddress() {
		return Strings.toStringNullProof(address, "");
	}

	@Override
	public String toString() {
		return "simulator connector to: " + Strings.toStringNullProof(address, "<null>");
	}

}
