package com.framsticks.experiment;


import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.communication.File;
import com.framsticks.core.ListChange;
import com.framsticks.params.EventListener;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.dispatching.Future;
import com.framsticks.util.dispatching.FutureHandler;

@FramsClassAnnotation
public abstract class NetLoadSaveLogic extends AbstractExperimentLogic {
	private static final Logger log = LogManager.getLogger(NetLoadSaveLogic.class);


	protected String option = "an option";

	/**
	 * @param experiment
	 */
	public NetLoadSaveLogic(Experiment parentExperiment) {
		super(parentExperiment);

		experiment.addSimulatorsListener(new EventListener<ListChange>() {

			@Override
			public void action(ListChange argument) {
				assert experiment.isActive();

				if (argument.hasHint("ready")) {
					final Simulator simulator = experiment.getSimulators().get(argument.getIdentifier());
					log.debug("simulator is ready: {}", simulator);

					netload(simulator, new FutureHandler<File>(simulator) {

						@Override
						protected void result(final File file) {
							simulator.uploadNet(file, new FutureHandler<Object>(this) {

								@Override
								protected void result(Object result) {
									log.debug("netload of {} done", file);
								}
							});
						}
					});
				}
			}
		});
	}

	public abstract void netload(Simulator simulator, Future<File> net);

	public abstract void netsave(Simulator simulator, File net);

	/**
	 * @return the option
	 */
	@ParamAnnotation
	public String getOption() {
		return option;
	}

	/**
	 * @param option the option to set
	 */
	@ParamAnnotation
	public void setOption(String option) {
		this.option = option;
	}

}
