package com.framsticks.util.dispatching;


public class BufferedDispatcher<C> {

	protected final RunnableQueue<C> queue = new RunnableQueue<>();

	protected Dispatcher<C> targetDispatcher;

	protected boolean buffer = false;

	/**
	 * @return the targetDispatcher
	 */
	public synchronized Dispatcher<C> getTargetDispatcher() {
		return targetDispatcher;
	}

	/**
	 * @param targetDispatcher the targetDispatcher to set
	 */
	public synchronized void setTargetDispatcher(Dispatcher<C> targetDispatcher) {
		this.targetDispatcher = targetDispatcher;
	}

	public synchronized boolean isActive() {
		if (targetDispatcher == null) {
			return false;
			// throw new FramsticksException().msg("no dispatcher is set for tree yet").arg("tree", this);
		}
		return targetDispatcher.isActive();
	}

	public synchronized void dispatch(final RunAt<? extends C> runnable) {
		if (targetDispatcher != null && !buffer) {
			targetDispatcher.dispatch(runnable);
			return;
		}
		queue.push(runnable);
	}

	public synchronized void setBuffer(final boolean buffer) {
		if (this.buffer == buffer) {
			return;
		}
		if (buffer) {
			this.buffer = true;
			return;
		}
		this.buffer = false;
		while (!queue.isEmpty()) {
			targetDispatcher.dispatch(queue.pollFirst());
		}

	}


}
