package com.framsticks.test;

import java.util.Map;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.core.ListChange;
import com.framsticks.params.EventListener;
import com.framsticks.params.EventListeners;
import com.framsticks.params.SimpleUniqueList;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.params.types.ProcedureParam;

@FramsClassAnnotation(
	order = {
		"name",
		"history",
		"history_changed",
		"appendHistory",
		"resetHistory",
		"children",
		"createChild",
		"children_changed"
	}
)
public class TestClass {
	private static final Logger log =
		LogManager.getLogger(TestClass.class);


	protected String name = "test";
	protected String history = "initial|";
	protected final EventListeners<TestChangeEvent> historyListeners = new EventListeners<>();

	protected final SimpleUniqueList<TestChild> children = new SimpleUniqueList<>(TestChild.class, 'c');

	/**
	 *
	 */
	public TestClass() {
	}

	/**
	 * @return the name
	 */
	@ParamAnnotation
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	@ParamAnnotation
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the history
	 */
	@ParamAnnotation
	public String getHistory() {
		return history;
	}

	/**
	 * @param history the history to set
	 */
	@ParamAnnotation
	public void setHistory(String history) {
		this.history = history;
	}

	/**
	 * @return the children
	 */
	@ParamAnnotation
	public Map<String, TestChild> getChildren() {
		return children.getView();
	}

	@ParamAnnotation(paramType = ProcedureParam.class)
	public int appendHistory(String line) {
		log.debug("appending '{}'", line);
		history = history + line + "|";
		fireHistoryChange();
		return history.length();
	}

	@ParamAnnotation(paramType = ProcedureParam.class)
	public void resetHistory() {
		log.debug("reseting");
		history = "";
		fireHistoryChange();
	}

	@ParamAnnotation(paramType = ProcedureParam.class)
	public void createChild(String name) {
		TestChild child = new TestChild(this);
		child.name = name;
		children.add(child);
	}

	protected void fireHistoryChange() {
		TestChangeEvent event = new TestChangeEvent();
		event.history = history;
		historyListeners.actionForAll(event);
	}


	@ParamAnnotation(id = "history_changed")
	public void addHistoryListener(EventListener<TestChangeEvent> listener) {
		historyListeners.add(listener);
	}

	@ParamAnnotation(id = "history_changed")
	public void removeHistoryListener(EventListener<TestChangeEvent> listener) {
		historyListeners.remove(listener);
	}

	@ParamAnnotation(id = "children_changed")
	public void addChildrenListener(EventListener<ListChange> listener) {
		children.addListener(listener);
	}

	@ParamAnnotation(id = "children_changed")
	public void removeChildrenListener(EventListener<ListChange> listener) {
		children.removeListener(listener);
	}

	@Override
	public String toString() {
		return "test class " + history;
	}

}
