package com.framsticks.params.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.framsticks.params.Param;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD, ElementType.METHOD})
public @interface ParamAnnotation {
	String name() default "";
	String id() default "";

	Class<? extends Param> paramType() default Param.class;
	String stringType() default "";

	String def() default "";
	String min() default "";
	String max() default "";

	String help() default "";
	int flags() default 0;
	int extra() default 0;
	// String group() default "";
}

