package com.framsticks.params;

import java.util.LinkedList;
import java.util.List;

public class EventListeners<A> {

	protected final List<EventListener<A>> listeners = new LinkedList<>();

	public void add(EventListener<A> listener) {
		listeners.add(listener);
	}

	public void remove(EventListener<A> listener) {
		listeners.remove(listener);
	}

	public void actionForAll(A argument) {
		for (EventListener<A> l : listeners) {
			l.action(argument);
		}
	}
}
