package com.framsticks.params;


import com.framsticks.params.types.EventParam;
import com.framsticks.params.types.ProcedureParam;


/**
 * The Interface Access. It's the most general class for storing data in
 * framsticks. In descriptions of methods names "property" and "parameter" are
 * synonyms.
 *
 * @author Jarek Szymczak <name.surname@gmail.com> (please replace name and
 *         surname with my personal data)
 */
public interface Access {

	Param getParam(int i);

	Param getParam(String id);

	String getId();

	int getParamCount();

	Object call(String id, Object[] arguments);

	Object call(ProcedureParam param, Object[] arguments);

	<T> T get(int i, Class<T> type);

	<T> T get(String id, Class<T> type);

	<T> T get(ValueParam param, Class<T> type);

	<T> int set(int i, T value);

	<T> int set(String id, T value);

	<T> int set(ValueParam param, T value);

	void reg(EventParam param, EventListener<?> listener);

	void regRemove(EventParam param, EventListener<?> listener);

	void save(SinkInterface sink);

	/**
	 * Removes all the properties values.
	 */
	void clearValues();

	Access select(Object object);

	Object getSelected();

	Access cloneAccess();

	Object createAccessee();

	Iterable<Param> getParams();

	FramsClass getFramsClass();

	void tryAutoAppend(Object object);

	int getCompositeParamCount();

	CompositeParam getCompositeParam(int number);

	ParamBuilder buildParam(ParamBuilder builder);


}
