package com.framsticks.gui.controls;

import com.framsticks.gui.Gui;
import com.framsticks.params.PrimitiveParam;
import com.framsticks.util.lang.Strings;

import javax.swing.*;
import java.awt.*;

@SuppressWarnings("serial")
public class TextFieldControl extends TextControl {


	private static final Color CORRECT_COLOR = new Color(180, 255, 215);
	private static final Color WRONG_COLOR = new Color(255, 180, 215);

	protected final JTextField textField;

	@Override
	protected boolean notifyOfChange() {
		boolean result = super.notifyOfChange();
		textField.setBackground(result ? CORRECT_COLOR : WRONG_COLOR);
		return result;
	}

	public TextFieldControl(PrimitiveParam<?> valueParam) {
		super(valueParam);
		textField = new JTextField();
		textField.setName("value");

		textField.setMinimumSize(new Dimension(0, Control.LINE_HEIGHT));
		this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Control.LINE_HEIGHT));

		addDefaultDocumentListener(textField);

		Gui.addLeftToLabel(this, textField);
	}

	@Override
	public void pushValueToUserInterfaceImpl(Object text) {
		textField.setText(Strings.toStringNullProof(text));
	}

	@Override
	public Object pullValueFromUserInterface() {
		return textField.getText();
	}

	@Override
	protected void updateEnabled(boolean enabled) {
		textField.setEnabled(enabled);
	}

}
