package com.framsticks.gui.controls;

import com.framsticks.core.Path;
import com.framsticks.gui.Frame;
import com.framsticks.gui.Gui;
import com.framsticks.params.Param;
import com.framsticks.params.types.ProcedureParam;
import com.framsticks.util.dispatching.ExceptionResultHandler;
import com.framsticks.util.dispatching.FutureHandler;
import com.framsticks.util.dispatching.ThrowExceptionHandler;

import javax.swing.*;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@SuppressWarnings("serial")
public class ProcedureControl extends HistoryControl implements ControlOwner {

	private static final Logger log = LogManager.getLogger(ProcedureControl.class);

	protected final JPanel argumentsPanel;

	final protected Map<String, ValueControl> components = new HashMap<>();

	public ProcedureControl(ProcedureParam procedureParam) {
		super(procedureParam);


		mainButton.setText("Call");
		mainButton.setName("call");


		argumentsPanel = new JPanel();
		argumentsPanel.setName("arguments");

		Gui.fillWithControls(this, argumentsPanel, procedureParam.getArgumentsType(), components, ValueControl.class);

		if (components.size() != procedureParam.getArgumentsType().size()) {
			mainButton.setEnabled(false);
		}

		mainButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {

				final Path path = getCurrentPath();

				final List<Object> arguments = new LinkedList<Object>();
				for (Param arg : getParam().getArgumentsType()) {
					Object value = components.get(arg.getId()).getCurrentValue();
					arguments.add(value);
					log.debug("argument {}: {}", arg, value);
				}
				//TODO FEH: make it show dialog
				callProcedure(path, getParam(), arguments.toArray());

			}
		});

		updateFoldState();
		Gui.setupTitledControl(this, argumentsPanel, controlRow, resultsScrollPane);

	}


	public static void callProcedure(final Path path, final ProcedureParam param, Object[] arguments) {
		final ExceptionResultHandler handler = ThrowExceptionHandler.getInstance();

		assert path.getTree().isActive();

		path.getTree().call(path, param, arguments, new FutureHandler<Object>(handler) {

			@Override
			public void result(Object result) {

			}
		});
	}

	@Override
	public ProcedureParam getParam() {
		return (ProcedureParam) param;
	}

	@Override
	protected void updateEnabled(boolean enabled) {
		mainButton.setEnabled(enabled);
		for (ValueControl vc : components.values()) {
			vc.setUserEnabled(enabled);
		}
	}

	@Override
	public Frame getFrame() {
		return owner.getFrame();
	}

	@Override
	public Path getCurrentPath() {
		return owner.getCurrentPath();
	}

	@Override
	public boolean onValueChange(ValueControl control, Object newValue) {
		return true;
	}

	@Override
	protected void refreshTable() {
		// TODO Auto-generated method stub

	}

	@Override
	protected void clearTable() {
		// TODO Auto-generated method stub

	}

}
