package com.framsticks.gui.controls;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import com.framsticks.gui.Gui;
import com.framsticks.params.Param;
import com.framsticks.util.swing.TooltipConstructor;

@SuppressWarnings("serial")
public abstract class HistoryControl extends Control {

	protected final JPanel controlRow;
	protected final JButton mainButton;
	protected final JCheckBox foldingCheckbox;
	protected final JButton clearButton;

	protected final JScrollPane resultsScrollPane;
	protected final JTable resultsTable;

	public HistoryControl(Param param) {
		super(param);

		this.setToolTipText(new TooltipConstructor()
			.append("name", param.getName())
			.append("id", param.getId())
			.append("help", param.getHelp())
			.build());

		controlRow = new JPanel();
		controlRow.setName("control_row");

		mainButton = new JButton();

		mainButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, LINE_HEIGHT));

		clearButton = new JButton("Clear");
		clearButton.setName("clear");

		foldingCheckbox = new JCheckBox("Fold");
		foldingCheckbox.setName("folding");
		foldingCheckbox.setSelected(true);

		foldingCheckbox.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				updateFoldState();
			}
		});


		clearButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				clearTable();
			}
		});



		Gui.layoutInRow(controlRow, mainButton, foldingCheckbox, clearButton);

		resultsTable = new JTable();
		resultsScrollPane = new JScrollPane(resultsTable);
		resultsTable.setShowGrid(false);


	}

	public boolean isFolded() {
		return foldingCheckbox.isSelected();
	}

	protected void updateFoldState() {
		int lines = isFolded() ? 1 : 5;
		int height = lines * LINE_HEIGHT;
		// resultsTable.getTableHeader().setVisible(!isFolded());
		resultsScrollPane.setColumnHeaderView(!isFolded() ? resultsTable.getTableHeader() : null);
		resultsScrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, height));
		resultsScrollPane.setPreferredSize(new Dimension(0, height));
		if (owner != null) {
			refreshTable();
		}
		this.revalidate();
		// foldingButton.setText(isFolded ? "Unfold" : "Fold");
	}

	protected abstract void refreshTable();

	protected abstract void clearTable();

}
