package com.framsticks.gui;


import java.awt.BorderLayout;
import java.awt.Dimension;
// import java.awt.Dimension;

import javax.swing.JPanel;
import javax.swing.JTextField;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.gui.controls.Control;
import com.framsticks.util.FramsticksException;
import com.framsticks.util.dispatching.Dispatcher;
import com.framsticks.util.dispatching.Dispatching;
import com.framsticks.util.dispatching.ExceptionResultHandler;
import com.framsticks.util.dispatching.RunAt;

public class StatusBar implements ExceptionResultHandler {
	private static final Logger log = LogManager.getLogger(StatusBar.class);

	protected JTextField statusBar;
	protected JPanel swing;
	protected ExceptionResultHandler exceptionHandler;
	protected final Dispatcher<?> dispatcher;

	/**
	 *
	 */
	public StatusBar(Dispatcher<?> dispatcher) {
		this.dispatcher = dispatcher;
	}

	@SuppressWarnings({"rawtypes", "unchecked"})
	public void showInfo(final Object value) {
		Dispatching.dispatchIfNotActive(dispatcher, new RunAt(this) {

			@Override
			protected void runAt() {
				String text = value.toString();
				log.info("info: {}", text);
				statusBar.setText(text);

			}
		});
	}

	@Override
	@SuppressWarnings({"rawtypes", "unchecked"})
	public void handle(final FramsticksException exception) {
		dispatcher.dispatch(new RunAt(this) {

			@Override
			protected void runAt() {
				log.error("error: {}", exception.getMessage());
				statusBar.setText(exception.getShortMessage(new StringBuilder()).toString());
				if (exceptionHandler != null) {
					exceptionHandler.handle(exception);
				}
			}
		});
	}

	public void initializeGui() {
		statusBar = new JTextField();
		statusBar.setEditable(false);

		swing = new JPanel();
		swing.setMaximumSize(new Dimension(Integer.MAX_VALUE, Control.LINE_HEIGHT));

		swing.setLayout(new BorderLayout());
		swing.add(statusBar, BorderLayout.CENTER);
		// swing.add(statusBar);
	}

	/**
	 * @return the swing
	 */
	public JPanel getSwing() {
		return swing;
	}

	/**
	 * @return the exceptionHandler
	 */
	public ExceptionResultHandler getExceptionHandler() {
		return exceptionHandler;
	}

	/**
	 * @param exceptionHandler the exceptionHandler to set
	 */
	public void setExceptionHandler(ExceptionResultHandler exceptionHandler) {
		this.exceptionHandler = exceptionHandler;
	}

}
