package com.framsticks.gui;

import com.framsticks.core.Path;
import com.framsticks.gui.controls.Control;
import com.framsticks.gui.controls.ControlOwner;
import com.framsticks.gui.controls.ValueControl;
import com.framsticks.params.Access;
import com.framsticks.params.Param;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import javax.swing.*;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import static com.framsticks.util.lang.Containers.filterInstanceof;

import com.framsticks.util.FramsticksException;

import static com.framsticks.core.TreeOperations.*;

@SuppressWarnings("serial")
public class ObjectPanel extends ModifiablePanel implements ControlOwner {

	private static final Logger log = LogManager.getLogger(ObjectPanel.class);

	final protected Map<String, Control> controls = new HashMap<String, Control>();
	final protected Map<String, ValueControl> valueControls = new HashMap<String, ValueControl>();

	protected final JPanel contentPanel;
	protected final JScrollPane scrollPane;

	public ObjectPanel(TreePanel.Parameters parameters, Collection<Param> params) {
		super(parameters);

		contentPanel = new JPanel();
		scrollPane = new JScrollPane(contentPanel);

		setupContentComponent(scrollPane);

		Gui.fillWithControls(this, contentPanel, params, controls, Control.class);
		setName(framsClass.getId());

		for (final ValueControl c : filterInstanceof(controls.values(), ValueControl.class)) {
			valueControls.put(c.getParam().getId(), c);
			c.setUserEnabled(true);
		}

		contentPanel.add(Box.createVerticalGlue());
		this.revalidate();
	}

	@Override
	protected void applyChanges() {
		assert frame.isActive();
		assert currentPath != null;
		treeAtFrame.pushUserChangesToTree(currentPath);
		refreshControlButtons();
	}


	@Override
	protected void revertChanges() {
		assert currentPath != null;
		removeSideNote(currentPath, treeAtFrame.getUserChangesKey());
		pullValuesFromLocalToUser(bindAccess(currentPath));
	}

	@Override
	public void pullValuesFromLocalToUser(Access access) {
		assert currentPath != null;
		log.debug("refreshing components");

		UserChanges userChanges = getSideNote(currentPath, treeAtFrame.getUserChangesKey());


		for (Map.Entry<String, ValueControl> e : valueControls.entrySet()) {
			String id = e.getKey();
			Object value;
			if (userChanges != null && userChanges.changes.containsKey(id)) {
				value = userChanges.changes.get(id);
			} else {
				value = access.get(id, Object.class);
			}

			e.getValue().pushValueToUserInterface(value);
		}

		for (Map.Entry<String, Control> e : controls.entrySet()) {
			e.getValue().refreshState();
		}

		refreshControlButtons();
		// ObjectPanel.this.revalidate();
	}

	@Override
	public String getTitle() {
		return "Properties";
	}

	@Override
	public void handle(FramsticksException exception) {
		frame.handle(exception);
	}

	@Override
	public Path getCurrentPath() {
		return super.getCurrentPath();
	}

	@Override
	public boolean onValueChange(ValueControl control, Object newValue) {
		if (currentPath == null) {
			return true;
		}
		boolean result = treeAtFrame.changeValue(currentPath.assureResolved().getTopObject(), control, newValue);
		refreshControlButtons();
		return result;
	}

}
