package com.framsticks.experiment;

import com.framsticks.params.ParamFlags;
import com.framsticks.params.UniqueObject;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.params.types.ProcedureParam;
import com.framsticks.remote.RemoteTree;
import com.framsticks.util.dispatching.AbstractJoinable;
import com.framsticks.util.dispatching.Dispatching;
import com.framsticks.util.dispatching.Joinable;
import com.framsticks.util.dispatching.JoinableParent;
import com.framsticks.util.dispatching.JoinableState;

@FramsClassAnnotation
public class Simulator extends AbstractJoinable implements JoinableParent, UniqueObject {
	protected String uid;

	protected final RemoteTree remoteTree = new RemoteTree();

	/**
	 *
	 */
	public Simulator() {
		super();
	}

	@ParamAnnotation
	public void setAddress(String address) {
		remoteTree.setAddress(address);
	}

	@ParamAnnotation(flags = ParamFlags.USERREADONLY)
	public String getAddress() {
		return remoteTree.getAddress();
	}

	@Override
	@ParamAnnotation
	public String getName() {

		return "simulator " + uid + " " + getAddress();
	}

	@Override
	@ParamAnnotation
	public String getUid() {
		return uid;
	}

	@Override
	public void setUid(String uid) {
		this.uid = uid;
	}

	/**
	 * @return the tree
	 */
	@ParamAnnotation
	public RemoteTree getRemoteTree() {
		return remoteTree;
	}

	@Override
	protected void joinableStart() {
		Dispatching.use(remoteTree, this);

	}

	@Override
	protected void joinableInterrupt() {
		Dispatching.drop(remoteTree, this);

	}

	@Override
	protected void joinableFinish() {

	}

	@Override
	protected void joinableJoin() throws InterruptedException {
		Dispatching.join(remoteTree);
	}

	@ParamAnnotation(paramType = ProcedureParam.class)
	public void init() {
	}

	@ParamAnnotation(paramType = ProcedureParam.class)
	public void start() {
	}

	@ParamAnnotation(paramType = ProcedureParam.class)
	public void stop() {
	}

	@Override
	public void childChangedState(Joinable joinable, JoinableState state) {
		proceedToState(state);
	}

}
