package com.framsticks.experiment;

import java.util.Map;

import com.framsticks.core.ListChange;
import com.framsticks.params.EventListener;
import com.framsticks.params.SimpleUniqueList;
import com.framsticks.params.annotations.AutoAppendAnnotation;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.dispatching.JoinableCollection;

@FramsClassAnnotation
public class Experiment extends JoinableCollection<Simulator> {

	protected final SimpleUniqueList<Simulator> simulators = new SimpleUniqueList<>(Simulator.class, 's');

	@ParamAnnotation
	public Map<String, Simulator> getSimulators() {
		return simulators.getView();
	}

	@ParamAnnotation(id = "simulators_changed")
	public void addSimulatorsListener(EventListener<ListChange> listener) {
		simulators.addListener(listener);
	}

	@ParamAnnotation(id = "simulators_changed")
	public void removeSimulatorsListener(EventListener<ListChange> listener) {
		simulators.removeListener(listener);
	}

	@AutoAppendAnnotation
	public void addSimulator(Simulator simulator) {
		simulators.add(simulator);
	}
}
