package com.framsticks.net.client3D;

//import java.io.*;
import java.util.ArrayList;

/**
 * Logger
 * 
 * @author vorg
 */
public class Log {
   ///private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.dd.MM HH:mm");
	private static Log instance;
	private ArrayList<ILogListener> listeners;
	private Boolean enabled = true;
   
	private Log() {
		listeners = new ArrayList<ILogListener>();
	}
   
	public void addLoggerListener(ILogListener listener) {
		listeners.add(listener);
	}
   
	public void removeLoggerListener(ILogListener listener) {
		listeners.remove(listener);
	}

	public void log(String text) {
		log("   ", text);
	}
   
	public void log(String category, String text) {
		if (enabled) {
			for(ILogListener listener : listeners) {
				listener.onMesssage(category, text);
			}
		}
	}
   
	public static Log getInstance() {
		if (instance == null) {
			instance = new Log();
		}
	   return instance;
	}
	
	public void setEnabled(Boolean state) {
		enabled = state;
	}
	
	public Boolean isEnabled() {
		return enabled;
	}
}